/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.recipes;

import dev.compactmods.crafting.CompactCrafting;
import dev.compactmods.crafting.api.catalyst.ICatalystMatcher;
import dev.compactmods.crafting.api.components.IRecipeBlockComponent;
import dev.compactmods.crafting.api.components.IRecipeComponent;
import dev.compactmods.crafting.api.components.IRecipeComponents;
import dev.compactmods.crafting.api.field.MiniaturizationFieldSize;
import dev.compactmods.crafting.api.recipe.IMiniaturizationRecipe;
import dev.compactmods.crafting.api.recipe.layers.IRecipeBlocks;
import dev.compactmods.crafting.api.recipe.layers.IRecipeLayer;
import dev.compactmods.crafting.api.recipe.layers.ISymmetricalLayer;
import dev.compactmods.crafting.api.recipe.layers.dim.IDynamicSizedRecipeLayer;
import dev.compactmods.crafting.api.recipe.layers.dim.IFixedSizedRecipeLayer;
import dev.compactmods.crafting.core.CCMiniaturizationRecipes;
import dev.compactmods.crafting.recipes.MiniaturizationRecipeCodec;
import dev.compactmods.crafting.recipes.components.EmptyBlockComponent;
import dev.compactmods.crafting.recipes.components.MiniaturizationRecipeComponents;
import dev.compactmods.crafting.recipes.layers.RecipeLayerUtil;
import dev.compactmods.crafting.recipes.setup.RecipeBase;
import dev.compactmods.crafting.server.ServerConfig;
import dev.compactmods.crafting.util.BlockSpaceUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class MiniaturizationRecipe
extends RecipeBase
implements IMiniaturizationRecipe {
    private int recipeSize = -1;
    private ResourceLocation id;
    private TreeMap<Integer, IRecipeLayer> layers = new TreeMap();
    private ICatalystMatcher catalyst = null;
    private ItemStack[] outputs = new ItemStack[0];
    private AABB dimensions = AABB.m_165882_((Vec3)Vec3.f_82478_, (double)0.0, (double)0.0, (double)0.0);
    private Map<String, Integer> cachedComponentTotals;
    private final IRecipeComponents components = new MiniaturizationRecipeComponents();
    public static final MiniaturizationRecipeCodec CODEC = new MiniaturizationRecipeCodec();

    void applyComponents(Map<String, IRecipeComponent> compMap) {
        this.components.clear();
        for (Map.Entry<String, IRecipeComponent> comp : compMap.entrySet()) {
            if (!(comp.getValue() instanceof IRecipeBlockComponent)) continue;
            this.components.registerBlock(comp.getKey(), (IRecipeBlockComponent)comp.getValue());
        }
        this.layers.forEach((i, l) -> {
            l.dropNonRequiredComponents(this.components);
            Set<String> missing = l.getComponents().stream().filter(key -> !this.components.hasBlock((String)key)).collect(Collectors.toSet());
            missing.forEach(needed -> this.components.registerBlock((String)needed, new EmptyBlockComponent()));
        });
    }

    public void applyLayers(List<IRecipeLayer> layers) {
        this.layers = new TreeMap();
        ArrayList<IRecipeLayer> rev = new ArrayList<IRecipeLayer>(layers);
        Collections.reverse(rev);
        for (int y = 0; y < rev.size(); ++y) {
            this.layers.put(y, rev.get(y));
        }
    }

    List<IRecipeLayer> getLayerListForCodecWrite() {
        return this.layers.descendingKeySet().stream().map(this.layers::get).collect(Collectors.toList());
    }

    void recalculateDimensions() {
        int height = this.layers.size();
        int x = 0;
        int z = 0;
        boolean hasAnyRigidLayers = this.layers.values().stream().anyMatch(l -> l instanceof IFixedSizedRecipeLayer);
        if (!hasAnyRigidLayers) {
            this.dimensions = new AABB(0.0, 0.0, 0.0, (double)this.recipeSize, (double)height, (double)this.recipeSize);
        } else {
            for (IRecipeLayer l2 : this.layers.values()) {
                if (!(l2 instanceof IFixedSizedRecipeLayer)) continue;
                AABB dimensions = ((IFixedSizedRecipeLayer)((Object)l2)).getDimensions();
                if (dimensions.m_82362_() > (double)x) {
                    x = (int)Math.ceil(dimensions.m_82362_());
                }
                if (!(dimensions.m_82385_() > (double)z)) continue;
                z = (int)Math.ceil(dimensions.m_82385_());
            }
            this.dimensions = new AABB(Vec3.f_82478_, new Vec3((double)x, (double)height, (double)z));
        }
        this.updateFluidLayerDimensions();
    }

    private void updateFluidLayerDimensions() {
        AABB footprint = BlockSpaceUtil.getLayerBounds(this.dimensions, 0);
        this.layers.values().stream().filter(l -> l instanceof IDynamicSizedRecipeLayer).forEach(dl -> ((IDynamicSizedRecipeLayer)((Object)dl)).setRecipeDimensions(footprint));
    }

    public boolean fitsInFieldSize(MiniaturizationFieldSize fieldSize) {
        int dim = fieldSize.getDimensions();
        return this.dimensions.m_82362_() <= (double)dim && this.dimensions.m_82376_() <= (double)dim && this.dimensions.m_82385_() <= (double)dim;
    }

    public boolean matches(IRecipeBlocks blocks) {
        boolean matchLogging = (Boolean)ServerConfig.RECIPE_MATCHING.get();
        if (!BlockSpaceUtil.boundsFitsInside(blocks.getFilledBounds(), this.dimensions)) {
            if (matchLogging) {
                CompactCrafting.LOGGER.debug("Failing recipe {} for being too large to fit in field.", (Object)this.id);
            }
            return false;
        }
        AABB filledBounds = blocks.getFilledBounds();
        Rotation[] validRotations = Rotation.values();
        HashMap layerRotationMatches = new HashMap(validRotations.length);
        for (Rotation r : validRotations) {
            layerRotationMatches.put(r, new HashSet(this.layers.size()));
        }
        for (Map.Entry entry : this.layers.entrySet()) {
            IRecipeLayer layer = (IRecipeLayer)entry.getValue();
            IRecipeBlocks layerBlocks = blocks.slice(BlockSpaceUtil.getLayerBounds(blocks.getFilledBounds(), (int)((Integer)entry.getKey()))).normalize();
            if (layer.requiresAllBlocksIdentified() && !layerBlocks.allIdentified()) {
                return false;
            }
            boolean firstMatched = layer.matches(this.components, layerBlocks);
            if (firstMatched) {
                ((Set)layerRotationMatches.get(Rotation.NONE)).add((Integer)entry.getKey());
            }
            if (layer instanceof ISymmetricalLayer && this.dimensions.m_82362_() == this.dimensions.m_82385_()) {
                if (!firstMatched) {
                    if (matchLogging) {
                        CompactCrafting.RECIPE_LOGGER.debug("[{}] Failing recipe layer {}; marked symmetrical and does not match its first rotation attempt.", (Object)this.id, entry.getKey());
                    }
                    return false;
                }
                for (Rotation r : validRotations) {
                    if (r == Rotation.NONE) continue;
                    ((Set)layerRotationMatches.get(r)).add((Integer)entry.getKey());
                }
                continue;
            }
            for (Rotation rotation : validRotations) {
                IRecipeBlocks rotated;
                if (rotation == Rotation.NONE || !layer.matches(this.components, rotated = RecipeLayerUtil.rotate(layerBlocks, rotation))) continue;
                ((Set)layerRotationMatches.get(rotation)).add((Integer)entry.getKey());
            }
        }
        Optional<Rotation> firstMatched = layerRotationMatches.entrySet().stream().filter(ent -> ((Set)ent.getValue()).equals(this.layers.keySet())).map(Map.Entry::getKey).findFirst();
        return firstMatched.isPresent();
    }

    @Override
    public ItemStack[] getOutputs() {
        return (ItemStack[])Stream.of(this.outputs).map(ItemStack::m_41777_).toArray(ItemStack[]::new);
    }

    public Map<String, Integer> getComponentTotals() {
        if (this.cachedComponentTotals != null) {
            return this.cachedComponentTotals;
        }
        HashMap<String, Integer> totals = new HashMap<String, Integer>();
        this.components.getAllComponents().keySet().forEach(comp -> {
            int count = this.getComponentRequiredCount((String)comp);
            totals.put((String)comp, count);
        });
        this.cachedComponentTotals = totals;
        return totals;
    }

    public int getComponentRequiredCount(String i) {
        if (!this.components.hasBlock(i)) {
            return 0;
        }
        return this.layers.values().stream().map(IRecipeLayer::getComponentTotals).map(totals -> Optional.ofNullable((Integer)totals.get(i)).orElse(0)).mapToInt(Integer::intValue).sum();
    }

    @Override
    public AABB getDimensions() {
        return this.dimensions;
    }

    @Override
    public Optional<IRecipeLayer> getLayer(int y) {
        if (y < this.layers.firstKey() || y > this.layers.lastKey()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.layers.get(y));
    }

    public int getNumberLayers() {
        return this.layers.size();
    }

    @Override
    public Stream<IRecipeLayer> getLayers() {
        return this.layers.values().stream();
    }

    @Override
    public IRecipeComponents getComponents() {
        return this.components;
    }

    @Override
    public void setOutputs(Collection<ItemStack> outputs) {
        this.outputs = outputs.toArray(new ItemStack[0]);
    }

    @Override
    public ICatalystMatcher getCatalyst() {
        return this.catalyst;
    }

    @Override
    public int getCraftingTime() {
        return 200;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)CCMiniaturizationRecipes.MINIATURIZATION_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return CCMiniaturizationRecipes.MINIATURIZATION_RECIPE_TYPE;
    }

    @Override
    public ResourceLocation getRecipeIdentifier() {
        return this.id;
    }

    @Override
    public void setId(ResourceLocation recipeId) {
        this.id = recipeId;
    }

    public boolean hasSpecifiedSize() {
        return MiniaturizationFieldSize.canFitDimensions(this.recipeSize);
    }

    public int getRecipeSize() {
        return this.recipeSize;
    }

    public void setRecipeSize(int size) {
        if (!MiniaturizationFieldSize.canFitDimensions(size)) {
            return;
        }
        this.recipeSize = size;
        this.recalculateDimensions();
    }

    public void setCatalyst(ICatalystMatcher catalyst) {
        this.catalyst = catalyst;
    }
}

